/*******************************************************************************
* File Name: TXOUT.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_TXOUT_H) /* Pins TXOUT_H */
#define CY_PINS_TXOUT_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "TXOUT_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    TXOUT_Write(uint8 value) ;
void    TXOUT_SetDriveMode(uint8 mode) ;
uint8   TXOUT_ReadDataReg(void) ;
uint8   TXOUT_Read(void) ;
uint8   TXOUT_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define TXOUT_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define TXOUT_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define TXOUT_DM_RES_UP          PIN_DM_RES_UP
#define TXOUT_DM_RES_DWN         PIN_DM_RES_DWN
#define TXOUT_DM_OD_LO           PIN_DM_OD_LO
#define TXOUT_DM_OD_HI           PIN_DM_OD_HI
#define TXOUT_DM_STRONG          PIN_DM_STRONG
#define TXOUT_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define TXOUT_MASK               TXOUT__MASK
#define TXOUT_SHIFT              TXOUT__SHIFT
#define TXOUT_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define TXOUT_PS                     (* (reg8 *) TXOUT__PS)
/* Data Register */
#define TXOUT_DR                     (* (reg8 *) TXOUT__DR)
/* Port Number */
#define TXOUT_PRT_NUM                (* (reg8 *) TXOUT__PRT) 
/* Connect to Analog Globals */                                                  
#define TXOUT_AG                     (* (reg8 *) TXOUT__AG)                       
/* Analog MUX bux enable */
#define TXOUT_AMUX                   (* (reg8 *) TXOUT__AMUX) 
/* Bidirectional Enable */                                                        
#define TXOUT_BIE                    (* (reg8 *) TXOUT__BIE)
/* Bit-mask for Aliased Register Access */
#define TXOUT_BIT_MASK               (* (reg8 *) TXOUT__BIT_MASK)
/* Bypass Enable */
#define TXOUT_BYP                    (* (reg8 *) TXOUT__BYP)
/* Port wide control signals */                                                   
#define TXOUT_CTL                    (* (reg8 *) TXOUT__CTL)
/* Drive Modes */
#define TXOUT_DM0                    (* (reg8 *) TXOUT__DM0) 
#define TXOUT_DM1                    (* (reg8 *) TXOUT__DM1)
#define TXOUT_DM2                    (* (reg8 *) TXOUT__DM2) 
/* Input Buffer Disable Override */
#define TXOUT_INP_DIS                (* (reg8 *) TXOUT__INP_DIS)
/* LCD Common or Segment Drive */
#define TXOUT_LCD_COM_SEG            (* (reg8 *) TXOUT__LCD_COM_SEG)
/* Enable Segment LCD */
#define TXOUT_LCD_EN                 (* (reg8 *) TXOUT__LCD_EN)
/* Slew Rate Control */
#define TXOUT_SLW                    (* (reg8 *) TXOUT__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define TXOUT_PRTDSI__CAPS_SEL       (* (reg8 *) TXOUT__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define TXOUT_PRTDSI__DBL_SYNC_IN    (* (reg8 *) TXOUT__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define TXOUT_PRTDSI__OE_SEL0        (* (reg8 *) TXOUT__PRTDSI__OE_SEL0) 
#define TXOUT_PRTDSI__OE_SEL1        (* (reg8 *) TXOUT__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define TXOUT_PRTDSI__OUT_SEL0       (* (reg8 *) TXOUT__PRTDSI__OUT_SEL0) 
#define TXOUT_PRTDSI__OUT_SEL1       (* (reg8 *) TXOUT__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define TXOUT_PRTDSI__SYNC_OUT       (* (reg8 *) TXOUT__PRTDSI__SYNC_OUT) 


#if defined(TXOUT__INTSTAT)  /* Interrupt Registers */

    #define TXOUT_INTSTAT                (* (reg8 *) TXOUT__INTSTAT)
    #define TXOUT_SNAP                   (* (reg8 *) TXOUT__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins TXOUT_H */


/* [] END OF FILE */
