/*******************************************************************************
* File Name: VDACQ_PM.c  
* Version 1.50
*
*  Description:
*     This file provides the power management source code to API for the
*     VDAC8.  
*
*   Note:
*     None
*
*******************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "VDACQ.h"

static VDACQ_backupStruct VDACQ_backup;


/*******************************************************************************
* Function Name: VDACQ_SaveConfig
********************************************************************************
* Summary:
*     Save the current user configuration
*
* Parameters:  
*  void  
*
* Return: 
*  void
*
* Reenrancy: 
*  No
*
*******************************************************************************/
void VDACQ_SaveConfig(void)
{
    VDACQ_backup.data_value = VDACQ_Data;
}


/*******************************************************************************
* Function Name: VDACQ_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the current user configuration.
*
* Parameters:  
*  void
*
* Return: 
*  void
*
* Reenrancy: 
*  No
*
*******************************************************************************/
void VDACQ_RestoreConfig(void)
{
    VDACQ_Data = VDACQ_backup.data_value;
}


/*******************************************************************************
* Function Name: VDACQ_Sleep
********************************************************************************
* Summary:
*     Stop and Save the user configuration
*
* Parameters:  
*  void:  
*
* Return: 
*  void
*
* Global variables:
*  VDACQ_backup.enableState:  Is modified depending on the enable state
*  of the block before entering sleep mode.
*
* Reenrancy: 
*  No
*
*******************************************************************************/
void VDACQ_Sleep(void)
{
    /* Save VDAC8's enable state */    
    if(VDACQ_ACT_PWR_EN == (VDACQ_PWRMGR & VDACQ_ACT_PWR_EN))
    {
        /* VDAC8 is enabled */
        VDACQ_backup.enableState = 1u;
    }
    else
    {
        /* VDAC8 is disabled */
        VDACQ_backup.enableState = 0u;
    }
    
    VDACQ_Stop();
    VDACQ_SaveConfig();
}


/*******************************************************************************
* Function Name: VDACQ_Wakeup
********************************************************************************
*
* Summary:
*  Restores and enables the user configuration
*  
* Parameters:  
*  void
*
* Return: 
*  void
*
* Global variables:
*  VDACQ_backup.enableState:  Is used to restore the enable state of 
*  block on wakeup from sleep mode.
*
* Reenrancy: 
*  Yes
*
*******************************************************************************/
void VDACQ_Wakeup(void) 
{
    VDACQ_RestoreConfig();
    
    if(VDACQ_backup.enableState == 1u)
    {
        /* Enable VDAC8's operation */
        VDACQ_Enable();

        /* Restore the data register */
        VDACQ_SetValue(VDACQ_Data);
    } /* Do nothing if VDAC8 was disabled before */    
}


/* [] END OF FILE */
