/*******************************************************************************
* File Name: TXOUT.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "TXOUT.h"


/*******************************************************************************
* Function Name: TXOUT_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void TXOUT_Write(uint8 value) 
{
    uint8 staticBits = TXOUT_DR & ~TXOUT_MASK;
    TXOUT_DR = staticBits | ((value << TXOUT_SHIFT) & TXOUT_MASK);
}


/*******************************************************************************
* Function Name: TXOUT_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void TXOUT_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(TXOUT_0, mode);
}


/*******************************************************************************
* Function Name: TXOUT_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro TXOUT_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 TXOUT_Read(void) 
{
    return (TXOUT_PS & TXOUT_MASK) >> TXOUT_SHIFT;
}


/*******************************************************************************
* Function Name: TXOUT_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 TXOUT_ReadDataReg(void) 
{
    return (TXOUT_DR & TXOUT_MASK) >> TXOUT_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(TXOUT_INTSTAT) 

    /*******************************************************************************
    * Function Name: TXOUT_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 TXOUT_ClearInterrupt(void) 
    {
        return (TXOUT_INTSTAT & TXOUT_MASK) >> TXOUT_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
