/*******************************************************************************
* File Name: VDACI_PM.c  
* Version 1.50
*
*  Description:
*     This file provides the power management source code to API for the
*     VDAC8.  
*
*   Note:
*     None
*
*******************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "VDACI.h"

static VDACI_backupStruct VDACI_backup;


/*******************************************************************************
* Function Name: VDACI_SaveConfig
********************************************************************************
* Summary:
*     Save the current user configuration
*
* Parameters:  
*  void  
*
* Return: 
*  void
*
* Reenrancy: 
*  No
*
*******************************************************************************/
void VDACI_SaveConfig(void)
{
    VDACI_backup.data_value = VDACI_Data;
}


/*******************************************************************************
* Function Name: VDACI_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the current user configuration.
*
* Parameters:  
*  void
*
* Return: 
*  void
*
* Reenrancy: 
*  No
*
*******************************************************************************/
void VDACI_RestoreConfig(void)
{
    VDACI_Data = VDACI_backup.data_value;
}


/*******************************************************************************
* Function Name: VDACI_Sleep
********************************************************************************
* Summary:
*     Stop and Save the user configuration
*
* Parameters:  
*  void:  
*
* Return: 
*  void
*
* Global variables:
*  VDACI_backup.enableState:  Is modified depending on the enable state
*  of the block before entering sleep mode.
*
* Reenrancy: 
*  No
*
*******************************************************************************/
void VDACI_Sleep(void)
{
    /* Save VDAC8's enable state */    
    if(VDACI_ACT_PWR_EN == (VDACI_PWRMGR & VDACI_ACT_PWR_EN))
    {
        /* VDAC8 is enabled */
        VDACI_backup.enableState = 1u;
    }
    else
    {
        /* VDAC8 is disabled */
        VDACI_backup.enableState = 0u;
    }
    
    VDACI_Stop();
    VDACI_SaveConfig();
}


/*******************************************************************************
* Function Name: VDACI_Wakeup
********************************************************************************
*
* Summary:
*  Restores and enables the user configuration
*  
* Parameters:  
*  void
*
* Return: 
*  void
*
* Global variables:
*  VDACI_backup.enableState:  Is used to restore the enable state of 
*  block on wakeup from sleep mode.
*
* Reenrancy: 
*  Yes
*
*******************************************************************************/
void VDACI_Wakeup(void) 
{
    VDACI_RestoreConfig();
    
    if(VDACI_backup.enableState == 1u)
    {
        /* Enable VDAC8's operation */
        VDACI_Enable();

        /* Restore the data register */
        VDACI_SetValue(VDACI_Data);
    } /* Do nothing if VDAC8 was disabled before */    
}


/* [] END OF FILE */
