Table 2
#!/usr/bin/octave
#
printf("\n\n      OCTAVE L-NETWORK DESIGN SCRIPT");
rt = input("\n\n  ENTER TERMINATING RESISTANCE: ");
xt = input("   ENTER TERMINATING REACTANCE: ");
rs = input("       ENTER SOURCE RESISTANCE: ");
xs = input("        ENTER SOURCE REACTANCE: ");
a = rs - rt;
b = 2 * rs * xt;
c = rs * rt ^ 2 + rs * xt ^ 2;
reversed = 0;
if ((b ^ 2 - 4 * a * c) < 0)
   reversed = 1;
   rtemp = rt;
   rt = rs;
   rs = rtemp;
   xtemp = xt;
   xt = xs;
   xs = xtemp;
   a = rs - rt;
   b = 2 * rs * xt;    
   b = 2 * rs * xt;    
   c = rs * rt ^ 2 + rs * xt ^ 2;
endif
if (rt == rs)
   printf("\n  L-NETWORK NOT SUITABLE FOR MATCHING\
 IDENTICAL SOURCE AND LOAD RESISTANCES.  \n\n");
 exit;
else
   xnp = (-b + sqrt(b ^ 2 - 4 * a * c)) / (2 * a);
   zn = (1j * xnp * (rt + 1j * xt)) / (1j * xnp + rt + 1j * xt);
   xns = -imag(zn);
   if(reversed == 0)   
      printf("\n\n         *** FIRST OPTION: SERIES LEG TOWARD SOURCE ***");
   else
      printf("\n\n         *** FIRST OPTION: SERIES LEG TOWARD LOAD ***");
   endif
   printf("\n    SERIES ELEMENT REACTANCE = %g", (xns + xs));
   printf("  PARALLEL ELEMENT REACTANCE = %g\n", xnp);
   xnp = (-b - sqrt(b ^ 2 - 4 * a * c)) / (2 * a);
   zn = (1j * xnp * (rt + 1j * xt)) / (1j * xnp + rt + 1j * xt);
   xns = -imag(zn);
   if(reversed == 0)
      printf("\n        *** SECOND OPTION: SERIES LEG TOWARD SOURCE ***");
   else
      printf("\n\n         *** SECOND OPTION: SERIES LEG TOWARD LOAD ***");
   endif
   printf("\n    SERIES ELEMENT REACTANCE = %g", (xns + xs));
   printf("  PARALLEL ELEMENT REACTANCE = %g", xnp);
   printf("\n");
   printf("\n");
endif
if (rs / rt <= (1 + (xt / rt) ^ 2))
   a = rt - rs;
   b = 2 * rt * xs;
   c = rt * rs ^ 2 + rt * xs ^ 2;
   if ((b ^ 2 - 4 * a * c) >= 0)
      xnp = (-b + sqrt(b ^ 2 - 4 * a * c)) / (2 * a);
      zn = (1j * xnp * (rs + 1j * xs)) / (1j * xnp + rs + 1j * xs);
      xns = -imag(zn);
      printf("         *** THIRD OPTION: SERIES LEG TOWARD LOAD ***");
      printf("\n    SERIES ELEMENT REACTANCE = %g", -(xns + xt));
      printf("  PARALLEL ELEMENT REACTANCE = %g\n",-xnp);
      xnp = (-b - sqrt(b ^ 2 - 4 * a * c)) / (2 * a);
      zn = (1j * xnp * (rs + 1j * xs)) / (1j * xnp + rs + 1j * xs);
      xns = -imag(zn);
      printf("\n        *** FOURTH OPTION: SERIES LEG TOWARD LOAD ***");
      printf("\n    SERIES ELEMENT REACTANCE = %g", -(xns + xt));
      printf("  PARALLEL ELEMENT REACTANCE = %g\n", -xnp);
      printf("\n\n");
   endif
endif
