/*  FFTS.C  */
#include<math.h>

void fwfft(int n,float xr[],float xi[])

/*  t->f FFT omitting post-butterflies bit-reversal  */
/*  From Oppenheim & Schaffer Fig. P6.5 page 332     */

/*  int   n;      Must be a positive power of 2      */
/*  float xr[], xi[];      Real & Imag data vectors  */
{
   float pi = 3.14159265358979;
   float tmpr, tmpi;  /*  Temporaries                */
   int idx, iptr, jptr, leap, jump; /*  Indices      */
   float twstr, twsti, turnr, turni;
   
   leap = n;
   while (leap > 1)
   {
      jump = leap>>1;  /*  Right shift 1  */
      turnr = 1.0;
      turni = 0.0;
      twstr =  cos(pi/jump);
      twsti = -sin(pi/jump);  /*  For t->f  */
      for (idx = 0; idx < jump; idx++)
      {
         for (iptr = idx; iptr < n; iptr = iptr + leap)
         {
            jptr = iptr + jump;
            tmpr = xr[iptr] - xr[jptr];
            tmpi = xi[iptr] - xi[jptr];
            xr[iptr] = xr[iptr] + xr[jptr];
            xi[iptr] = xi[iptr] + xi[jptr];
            xr[jptr] = tmpr*turnr - tmpi*turni;
            xi[jptr] = tmpr*turni + tmpi*turnr;
         }
         tmpr  = turnr*twstr - turni*twsti;
         turni = turnr*twsti + turni*twstr;
         turnr = tmpr;
      }
      leap = jump;
   }
/*  Bit-reversal data shuffling omitted from here  */
}

int bitrev(int n,float xr[],float xi[])

/*  BIT-REVersal data shuffling                  
    From "Cochannel" page B-8                    
    From Oppenheim & Schafer Fig. P6.5 page 332  
    Doing it twice is a no-op                    

int n;    Must be a positive power of 2  
float xr[], xi[];    Data vectors  */
{
   int nv2;               /*  n/2  */
   int ibtrv, idx, iptr;  /*  ibtrv is "bit-reversed" index  */
   float tmpr, tmpi;      /*  Temporaries  */
   
   ibtrv = 0;
   nv2 = n/2;
   for (idx = 0; idx < n-1; idx++)
   {
      if (idx < ibtrv)
      {  /* Swap buffer points */
         tmpr = xr[ibtrv];
         tmpi = xi[ibtrv];
         xr[ibtrv] = xr[idx];
         xi[ibtrv] = xi[idx];
         xr[idx] = tmpr;
         xi[idx] = tmpi;
      }
      /*  Increment the bit-reversed index  */
      iptr = nv2;
      while (ibtrv >= iptr)
      {
         ibtrv = ibtrv - iptr;
         iptr = iptr/2;
      }
      ibtrv = ibtrv + iptr;
   }
   return 0;
}

float srss(float x,float y)

/*  Square Root of Sum of Squares Approximator  */
/*  Approx sqrt(x*x+y*y) without squareroot     */
/*  RMS error 2.4 percent (32 dB down)          */

{
   float magx, magy, ans;
   
   magx=fabs(x);
   magy=fabs(y);
   if (magx > magy)
      ans = 0.95*magx + 0.4*magy;
   else
      ans = 0.95*magy + 0.4*magx;
   return ans;
}

void rvfft(int n,float xr[],float xi[])

/*  Reverse FFT (f->t) omitting bit-rev and div by n  */
/*  Based on "Cochannel" CFFT pages B-8 to B-9        */

/*  int   n    A positive power of 2                  */
/*  float xr[], xi[]    Real & Imag data vectors      */
{
   float pi = 3.14159265358979;
   float tmpr, tmpi;  /*  Temporaries  */
   int idx, iptr, jptr, leap, jump;  /*  Indices  */
   float twstr, twsti, turnr, turni; /*  Rotations  */

/*  Bit-reversal data shuffling omitted from here  */
   leap = 1;
   while (leap < n)
   {
      jump = leap;
      leap = leap*2;
      twstr = cos(pi/jump);
      twsti = sin(pi/jump);  /*  for f->t  */
      turnr = 1.0;
      turni = 0.0;
      for (idx = 0; idx < jump; idx++)
      {
         for (iptr = idx; iptr < n; iptr = iptr + leap)
         {
            jptr = iptr + jump;
            tmpr = xr[jptr]*turnr - xi[jptr]*turni;
            tmpi = xr[jptr]*turni + xi[jptr]*turnr;
            xr[jptr] = xr[iptr] - tmpr;
            xi[jptr] = xi[iptr] - tmpi;
            xr[iptr] = xr[iptr] + tmpr;
            xi[iptr] = xi[iptr] + tmpi;
         }
         tmpr  = turnr*twstr - turni*twsti;
         turni = turnr*twsti + turni*twstr;
         turnr = tmpr;
      }
   }
/*  Dividing data by n omitted from here  */
}
