/*  Search Histogram  SRCHIST.C  */

void srchist(int nbins, float bins[], float thresh,
	     int *pminwid, float *pctr)

/*  nbins   Number of histogram bins                 */
/*  bins    The histogram bins themselves            */
/*  thresh  Threshold for sum of bins                */
/*  minwid  Min width-1 of interval with sum >= thresh */
/*  ctr     Center of minwid bins interval           */
/*  Note:   Call using arguments &minwid and &ctr    */

{
   int lidx,hidx,oldlow,minlow;
   float sum;

   *pminwid=nbins;
   lidx=hidx=oldlow=minlow=0;
   sum=bins[0]; /* 2-18-98 */

   while(hidx<nbins)
   {
      while(sum<thresh && hidx<nbins)
      {  /*  Advance forward limit until sum>=thresh  */
	 hidx++;
	 if(hidx<nbins)
	    sum=sum+bins[hidx];
      }
      while(sum>=thresh && lidx<=hidx && hidx<nbins)
      {  /*  Advance rear limit until sum<thresh  */
	 sum=sum-bins[lidx];
	 oldlow=lidx;
	 lidx++;
      }
      if(hidx<nbins)
      {
	 if(hidx-oldlow<*pminwid)
	 {  /*  If intvl narrowest so far note it  */
	    *pminwid=hidx-oldlow;
	    minlow=oldlow;
	 }
      }
   }
   *pctr=minlow+*pminwid*0.5;
}
